/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.entity;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.entity.EntityKineticBullet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBulletRenderer
extends class_897<EntityKineticBullet> {
    public EntityBulletRenderer(class_5617.class_5618 pContext) {
        super(pContext);
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.DEFAULT_BULLET_MODEL);
    }

    public void render(EntityKineticBullet bullet, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        class_2960 gunId = bullet.getGunId();
        Optional<ClientGunIndex> optionalClientGunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (optionalClientGunIndex.isEmpty()) {
            return;
        }
        float @Nullable [] gunTracerColor = optionalClientGunIndex.get().getTracerColor();
        class_2960 ammoId = bullet.getAmmoId();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresent(ammoIndex -> {
            BedrockAmmoModel ammoEntityModel = ammoIndex.getAmmoEntityModel();
            class_2960 textureLocation = ammoIndex.getAmmoEntityTextureLocation();
            if (ammoEntityModel != null && textureLocation != null) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)bullet.field_5982, (float)bullet.method_36454()) - 180.0f));
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)bullet.field_6004, (float)bullet.method_36455())));
                poseStack.method_22903();
                poseStack.method_22904(0.0, 1.5, 0.0);
                poseStack.method_22905(-1.0f, -1.0f, 1.0f);
                ammoEntityModel.render(poseStack, class_811.field_4318, class_1921.method_23689((class_2960)textureLocation), packedLight, class_4608.field_21444);
                poseStack.method_22909();
            }
            if (bullet.isTracerAmmo()) {
                float[] tracerColor = Objects.requireNonNullElse(gunTracerColor, ammoIndex.getTracerColor());
                this.renderTracerAmmo(bullet, tracerColor, partialTicks, poseStack, packedLight);
            }
        });
    }

    public void renderTracerAmmo(EntityKineticBullet bullet, float[] tracerColor, float partialTicks, class_4587 poseStack, int packedLight) {
        EntityBulletRenderer.getModel().ifPresent(model -> {
            class_1297 shooter = bullet.method_24921();
            if (shooter == null) {
                return;
            }
            poseStack.method_22903();
            float width = 0.005f;
            class_243 bulletPosition = bullet.method_30950(partialTicks);
            double trailLength = 0.85 * bullet.method_18798().method_1033();
            double disToEye = bulletPosition.method_1022(shooter.method_5836(partialTicks));
            trailLength = Math.min(trailLength, disToEye * 0.8);
            if (this.field_4676.field_4692.method_31044().method_31034() && bullet.method_24921() instanceof class_746) {
                poseStack.method_22909();
                return;
            }
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)bullet.field_5982, (float)bullet.method_36454()) - 180.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)bullet.field_6004, (float)bullet.method_36455())));
            poseStack.method_22904(0.0, 0.0, trailLength / 2.0);
            poseStack.method_22905(width *= (float)Math.max(1.0, disToEye / 3.5), width, (float)trailLength);
            double bulletDistance = bulletPosition.method_1022(shooter.method_33571());
            if (bullet.field_6012 >= 5 || bulletDistance > 2.0) {
                class_1921 type = class_1921.method_23018((class_2960)InternalAssetLoader.DEFAULT_BULLET_TEXTURE, (float)15.0f, (float)15.0f);
                model.render(poseStack, class_811.field_4315, type, packedLight, class_4608.field_21444, tracerColor[0], tracerColor[1], tracerColor[2], 1.0f);
            }
            poseStack.method_22909();
        });
    }

    protected int getBlockLight(@NotNull EntityKineticBullet entityBullet, @NotNull class_2338 blockPos) {
        return 15;
    }

    public boolean shouldRender(EntityKineticBullet bullet, class_4604 camera, double pCamX, double pCamY, double pCamZ) {
        class_238 aabb = bullet.method_5830().method_1014(0.5);
        if (aabb.method_1013() || aabb.method_995() == 0.0) {
            aabb = new class_238(bullet.method_23317() - 2.0, bullet.method_23318() - 2.0, bullet.method_23321() - 2.0, bullet.method_23317() + 2.0, bullet.method_23318() + 2.0, bullet.method_23321() + 2.0);
        }
        return camera.method_23093(aabb);
    }

    public class_2960 getTexture(@NotNull EntityKineticBullet entity) {
        return null;
    }
}

